{{ ucfunc("put_docready_start") }}
    
  	var objWraper = jQuery('#{{uc_id}}');
  	var objItems = objWraper.find(".ue_timeline_item");
  	var itemActiveClass = "ue-active-item";
  	var confirmedActiveItemsNum = 0;
  
    function animateLine(items){

      const halfHeight = window.innerHeight / 2;

      items.forEach( (item, index) => {
        
        const iconBCR = item.querySelector('.ue_timeline_item_icon_holder').getBoundingClientRect();
        const line = item.querySelector('.ue_timeline_item_icon_line_mask');
        const lineHeight = line.parentElement.clientHeight;
        const lineTop = line.getBoundingClientRect().top;
        const lineBottom = line.getBoundingClientRect().bottom;
        const lineOffset = item.querySelector('.ue_timeline_item_icon_line_offset_mask')
        const lineOffsetTop = lineOffset.getBoundingClientRect().top;
        const lineOffsetBottom = lineOffset.getBoundingClientRect().bottom;
        const lineOffsetHeight = lineOffset.parentElement.clientHeight;

        var activeItems;
        var activeItemsNum;
        
        if (iconBCR.top <= halfHeight) { 
          item.classList.add('uc-active'); 
          activeItems = document.querySelectorAll('#{{uc_id}} .uc-active');
          activeItemsNum = activeItems.length;
        }

        if ( lineOffsetTop >= halfHeight) {
          lineOffset.style.height = '0%';
        } else if ( lineOffsetBottom <= halfHeight ) {
          lineOffset.style.height = '100%';
        }

        if ( iconBCR.top >= halfHeight ) { 
          item.classList.remove('uc-active');
          activeItems = document.querySelectorAll('#{{uc_id}} .uc-active');
          activeItemsNum = activeItems.length;
        }

        if ( lineTop >= halfHeight) {
          line.style.height = '0%';
        } else if ( lineBottom <= halfHeight ) {
          line.style.height = '100%';
        }

        if ( ( lineOffsetTop  <= halfHeight) && ( lineOffsetTop + lineHeight >= halfHeight ) ) {
          const scrolledAmount = halfHeight - lineOffsetTop;
          const normalizedScrolledAmount = ( scrolledAmount / lineOffsetHeight ) * 100;
          lineOffset.style.height = `${normalizedScrolledAmount}%`;
        }

        if ( ( lineTop  <= halfHeight) && ( lineTop + lineHeight >= halfHeight ) ) {
          const scrolledAmount = halfHeight - lineTop;
          const normalizedScrolledAmount = ( scrolledAmount / lineHeight ) * 100;
          line.style.height = `${normalizedScrolledAmount}%`;
        }
         
        var activeItems = document.querySelectorAll('#{{uc_id}} .uc-active');
        var activeItemsNum = activeItems.length;
        
        if(activeItemsNum > confirmedActiveItemsNum){        	
          confirmedActiveItemsNum++;  
          
          objItems.removeClass(itemActiveClass);
          objItems.eq(confirmedActiveItemsNum - 1).addClass(itemActiveClass);
       
        }
        
        if(activeItemsNum < confirmedActiveItemsNum){       
          
          activeItems = document.querySelectorAll('#{{uc_id}} .uc-active');
          activeItemsNum = activeItems.length;
          
          confirmedActiveItemsNum--;
          
          objItems.removeClass(itemActiveClass);
          objItems.eq(confirmedActiveItemsNum - 1).addClass(itemActiveClass);
        
        }
        
      });
      
    }
  
  	function initTimeline(){
      
      objItems = objWraper.find(".ue_timeline_item");
      confirmedActiveItemsNum = 0;
      var items = document.querySelectorAll('.ue_timeline_item_icon');
      
      animateLine(items);
      
    }

    initTimeline();

    document.addEventListener('scroll', initTimeline);
    window.addEventListener('resize', initTimeline); 
  	objWraper.on('uc_ajax_refreshed', initTimeline);
  
    var objRemoteOptions = {
      class_items:"ue_timeline_item",
      class_active:"ue-active-item",
      selector_item_trigger:null,
	  add_set_active_code:false,
    }; 	

    {{ucfunc("put_remote_parent_js","objWraper","objRemoteOptions")}}    
    	
{{ ucfunc("put_docready_end") }}